<?php
header('Content-Type: application/json');
require __DIR__ . '/../vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->safeLoad();

// Database configuration (Example using MySQLi)
$db = new mysqli(
    $_ENV['DB_HOST'],
    $_ENV['DB_USER'],
    $_ENV['DB_PASSWORD'],
    $_ENV['DB_NAME']
);

if ($db->connect_error) {
    http_response_code(500);
    die(json_encode(['error' => 'Database connection failed']));
}

try {
    // Get user ID from request
    $input = json_decode(file_get_contents('php://input'), true);
    $userId = $input['user_id'] ?? $_GET['user_id'] ?? null;
    
    if (empty($userId)) {
        throw new Exception("User ID is required");
    }

    // Fetch transactions from database
    $stmt = $db->prepare("
        SELECT transaction_id, amount, status, payment_mode, created_at 
        FROM transactions 
        WHERE user_id = ? 
        ORDER BY created_at DESC
        LIMIT 100
    ");
    $stmt->bind_param("s", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    $transactions = [];
    while ($row = $result->fetch_assoc()) {
        $transactions[] = [
            'transaction_id' => $row['transaction_id'],
            'amount'        => (float)$row['amount'],
            'status'        => $row['status'],
            'payment_mode'  => $row['payment_mode'],
            'date'          => $row['created_at'],
            'receipt_url'   => $_ENV['RECEIPT_BASE_URL'] . $row['transaction_id']
        ];
    }

    echo json_encode([
        'success' => true,
        'data' => [
            'user_id' => $userId,
            'count' => count($transactions),
            'transactions' => $transactions
        ]
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
} finally {
    $db->close();
}