<?php
include 'db.php';

// Start session with secure cookie parameters
session_set_cookie_params([
    'lifetime' => 0,              // Session cookie expires when the browser closes
    'path' => '/',                // Cookie is available in the entire domain
    'domain' => '',               // Default to the current domain
    'secure' => true,             // Cookie only sent over HTTPS
    'httponly' => true,           // Cookie is not accessible via JavaScript
    'samesite' => 'None',         // Explicitly set SameSite attribute to None
]);

session_start();
header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"));

// Check if it's an OTP *verification* request
if (isset($data->otp)) {
    // OTP Verification and Database Insertion
    if (!isset($data->phone)) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Phone is required for verification."]);
        exit();
    }

    $phone = $data->phone;
    $received_otp = $data->otp;
    

    if (!isset($_SESSION['otp'][$phone]) || !isset($_SESSION['otp_expiry'][$phone]) || time() > $_SESSION['otp_expiry'][$phone] || $_SESSION['otp'][$phone] != $received_otp) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Invalid or expired OTP."]);
        unset($_SESSION['otp'][$phone]);
        unset($_SESSION['otp_expiry'][$phone]);
        exit();
    }

    unset($_SESSION['otp'][$phone]);
    unset($_SESSION['otp_expiry'][$phone]);
    
    // Remove cookies (if applicable)
    if (isset($_COOKIE['PHPSESSID'])) {
        setcookie("PHPSESSID", "", time() - 3600, "/");
    }

    if (!isset($_SESSION['registration_data'])) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Registration data not found in session."]);
        exit();
    }

    $registration_data = $_SESSION['registration_data'];
    unset($_SESSION['registration_data']);

    $first_name = $registration_data['first_name'];
    $last_name = $registration_data['last_name'];
    $email = $registration_data['email'];
    $address = $registration_data['address'];
    $password = password_hash($registration_data['password'], PASSWORD_DEFAULT); // Hashing the password
    $photo = $registration_data['photo'];

    $query = "INSERT INTO users (first_name, last_name, email, phone, address, password, reset_token, token_expiry, status, photo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);

    if ($stmt->execute([$first_name, $last_name, $email, $phone, $address, $password, '', NULL, 'Active', ''])) {
        http_response_code(201);
        echo json_encode(["statusCode" => "200","status" => "success", "message" => "User registered successfully."]);
    } else {
        http_response_code(500);
        echo json_encode(["statusCode" => "201","status" => "error", "message" => "User registration failed."]);
    }
} else {
    // Initial Registration (Generate and send OTP)
    if (
        !isset($data->firstname) ||
        !isset($data->lastname) ||
        !isset($data->email) ||
        !isset($data->phone) ||
        !isset($data->address) ||
        !isset($data->password) ||
        !isset($data->photo)
    ) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "All fields are required."]);
        exit();
    }

    $first_name = $data->firstname;
    $last_name = $data->lastname;
    $email = $data->email;
    $phone = $data->phone;
    $address = $data->address;
    //$password = password_hash($data->password, PASSWORD_DEFAULT);
    $password = $data->password;
    $status = 'Active';
    $photo = $data->photo;

    // Store registration data in session
    $_SESSION['registration_data'] = [
        'first_name' => $first_name,
        'last_name' => $last_name,
        'email' => $email,
        'phone' => $phone,
        'address' => $address,
        'password' => $password,
        'status' => 'Active',
        'photo' => $photo
    ];

    // Generate and store OTP
    $otp = rand(100000, 999999);
    $_SESSION['otp'][$phone] = $otp;
    $_SESSION['otp_expiry'][$phone] = time() + 300; // 5 minutes expiry
    
    // Send OTP via email
    $subject = "Your OTP for Registration";
    $message = "Dear $first_name $last_name,\n\nYour One-Time Password (OTP) for registration is: $otp\n\nThis OTP will expire in 5 minutes.\n\nThank you!";
    $headers = "From: noreply@yourdomain.com\r\n";
    $headers .= "Reply-To: noreply@yourdomain.com\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
    
    if (mail($email, $subject, $message, $headers)) {
    echo json_encode(["statusCode" => "200", "status" => "otp_sent", "otp" =>$otp,  "message" => "OTP sent to your email for verification."]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to send OTP to email. Please try again."]);
    }
    exit();
}
?>