<?php
include 'db.php';

// Set content type to JSON
header('Content-Type: application/json');

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

if (is_array($data) && isset($data['user_id'], $data['unique_booking_id'], $data['rating'], $data['feedback'])) {
      $user_id = $data['user_id'];
      $booking_id = $data['unique_booking_id'];
      $rating = $data['rating'];
      $feedback = $data['feedback'];
    } else {
      // Handle missing or invalid data (e.g., send an error response)
      http_response_code(400); // Bad Request
      echo json_encode(array("error" => "Missing or invalid data.  Please provide user_id, booking_id, rating, and feedback."));
      exit; // Stop further execution
    }



    // Prepare and execute the SQL query (using prepared statements for security)
    $sql = $conn->prepare("INSERT INTO ratings_feedback (user_id, unique_booking_id, rating, feedback, created_at) VALUES (?, ?, ?, ?)");  // Replace 'ratings_feedback' with your actual table name
    $stmt->bind_param("iiis", $user_id, $unique_booking_id, $rating, $feedback); // "iiis" means integer, integer, integer, string
    
    $stmt = $conn->prepare($stmt);

try {
    $stmt->execute([$user_id, $unique_booking_id, $rating, $feedback]);
} catch (PDOException $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
    exit;
}

    if ($stmt->execute()) {
        // Successful insertion
        http_response_code(201); // Created
        echo json_encode(array("message" => "Data saved successfully")); // Respond with a success message
    } else {
        // Error during insertion
        http_response_code(500); // Internal Server Error
        echo json_encode(array("error" => "Error saving data: " . $stmt->error));
    }

    $stmt->close();

$conn->close();

?>