<?php

require_once '../vendor/autoload.php'; // Include Composer autoloader

use PhonePe\Env;
use PhonePe\payments\v2\standardCheckout\StandardCheckoutClient;
use PhonePe\payments\v2\models\request\builders\StandardCheckoutPayRequestBuilder;

$clientId = "SU2508192000203984711227";              // Replace with your Client ID
$clientVersion = 1;                        // Replace with your Client Version
$clientSecret = "6553a9d6-2e7d-497f-85be-be87e8fc4dc4";      // Replace with your Client Secret
$merchantId = "M233EMM5ZNXTQ";          // Replace with your Merchant ID
$env = Env::PRODUCTION;                    // Use Env::SANDBOX for testing

$client = StandardCheckoutClient::getInstance(
    $clientId,
    $clientVersion,
    $clientSecret,
    $env
);

// Check if orderId is passed via the query string
if (isset($_GET['orderId'])) {
    $orderId = $_GET['orderId'];
} else {
    echo json_encode(['error' => 'orderId parameter is missing']);
}

try {
    $merchantOrderId = $orderId; // Unique order ID
    $amount = 100; // Amount in paisa (e.g., 1000 = ₹10.00)
    $redirectUrl = "https://vsnl.online/zencare/#/payment-response"; // URL to which PhonePe will redirect after payment
    $message = "Your order details";

    // Build the payment request using the builder
    $payRequest = StandardCheckoutPayRequestBuilder::builder()
    ->merchantOrderId($merchantOrderId)
    ->amount($amount)
    ->redirectUrl($redirectUrl)
    ->message($message)  //Optional Message
    ->build();
    
    // Initiate the payment
    $payResponse = $client->pay($payRequest);
    
    // Respond with success
    echo json_encode($payResponse);
    
    // Handle the response
    if ($payResponse->getState() === "PENDING") {
        // Redirect the user to the PhonePe payment page
        header("Location: " . $payResponse->getRedirectUrl());
        exit();
    } else {
        // Handle the error (e.g., display an error message)
        echo "Payment initiation failed: " . $payResponse->getState();
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
