<?php
header('Content-Type: application/json');
require __DIR__ . '/../vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

// Initialize PhonePe Client
$client = new PhonePe\Client([
    'merchantId' => $_ENV['PHONEPE_MERCHANT_ID'],
    'saltKey'    => $_ENV['PHONEPE_SALT_KEY'],
    'saltIndex'  => $_ENV['PHONEPE_SALT_INDEX'],
    'env'        => $_ENV['PHONEPE_ENV']
]);

try {
    // Get transaction ID from request
    $input = json_decode(file_get_contents('php://input'), true);
    $transactionId = $input['transaction_id'] ?? null;
    
    if (empty($transactionId)) {
        throw new Exception("Transaction ID is required");
    }

    // Verify payment status
    $response = $client->payment->checkStatus($transactionId);
    
    
    if ($response['code'] === 'PAYMENT_SUCCESS') {
    $status = 'success';
} elseif ($response['code'] === 'PAYMENT_ERROR') {
    $status = 'failed';
} else {
    $status = 'pending';
}

    // Return standardized response
    echo json_encode([
        'status' => $status,
        'data'   => [
            'transaction_id' => $response['merchantTransactionId'],
            'amount'        => $response['amount'] / 100, // Convert paise to ₹
            'timestamp'     => $response['timestamp'],
            'gateway_data'  => $response  // Raw PhonePe response
        ]
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
}