<?php
header("Content-Type: application/json");
require_once "../vendor/autoload.php"; // Composer autoloader

use PhonePe\payments\v2\standardCheckout\StandardCheckoutClient;
use PhonePe\Env;

$clientId = "SU2504081812287929391652";              // Replace with your Client ID
$clientVersion = 1;                        // Replace with your Client Version
$clientSecret = "09edc84a-35f8-4607-b122-16af6a47c0f4";      // Replace with your Client Secret
$merchantId = "M233EMM5ZNXTQ";          // Replace with your Merchant ID
$env = Env::PRODUCTION;                    // Use Env::SANDBOX for testing

// Get transaction ID from request (POST or GET)
$merchantTransactionId = $_POST['transactionId'] ?? $_GET['transactionId'] ?? null;

if (!$merchantTransactionId) {
    echo json_encode([
        "success" => false,
        "message" => "Missing transactionId"
    ]);
    exit;
}

try {
    // Create PhonePe client
    $client = StandardCheckoutClient::getInstance(
        $clientId,
        $clientVersion,
        $clientSecret,
        $env
    );

    // Fetch order status
    $statusCheckResponse = $client->getOrderStatus($merchantTransactionId, true);

    $state = $statusCheckResponse->getState();

    // Prepare JSON response
    $response = [
        "success" => true,
        "merchantId" => $statusCheckResponse->getMerchantId(),
        "merchantTransactionId" => $statusCheckResponse->getMerchantTransactionId(),
        "transactionId" => $statusCheckResponse->getTransactionId(),
        "state" => $state,
        "amount" => $statusCheckResponse->getAmount(),
        "paymentInstrument" => $statusCheckResponse->getPaymentInstrument(),
    ];

    // Handle DB update here if needed
    if ($state === "SUCCESS") {
        // ✅ Update your DB order to Paid
    } elseif ($state === "FAILED") {
        // ❌ Mark as failed
    } elseif ($state === "PENDING") {
        // ⏳ Mark as pending
    }

    echo json_encode($response);

} catch (\PhonePe\common\exceptions\PhonePeException $e) {
    echo json_encode([
        "success" => false,
        "message" => $e->getMessage()
    ]);
}