<?php
header('Content-Type: application/json');
require __DIR__ . '/../vendor/autoload.php';

// Load environment variables (if using phpdotenv)
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

// Initialize PhonePe Client
$client = new PhonePe\Client([
    'merchantId' => $_ENV['PHONEPE_MERCHANT_ID'],
    'saltKey'    => $_ENV['PHONEPE_SALT_KEY'],
    'saltIndex'  => $_ENV['PHONEPE_SALT_INDEX'] ?? 1,
    'env'        => $_ENV['PHONEPE_ENV'] ?? 'sandbox'
]);

try {
    // Get input data
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Validate required fields
    if (empty($input['amount']) || !is_numeric($input['amount'])) {
        throw new Exception("Amount is required and must be numeric");
    }

    // Create order
    $response = $client->payment->initiate([
        'merchantTransactionId' => 'TXN_' . uniqid(),
        'amount'                => $input['amount'] * 100, // Convert to paise
        'merchantUserId'        => $input['user_id'] ?? 'GUEST_' . rand(1000,9999),
        'redirectUrl'           => $_ENV['PHONEPE_REDIRECT_URL'],
        'callbackUrl'          => $_ENV['PHONEPE_CALLBACK_URL'],
        'mobileNumber'         => $input['phone'] ?? null
    ]);

    // Return payment URL
    echo json_encode([
        'success' => true,
        'payment_url' => $response['data']['instrumentResponse']['redirectInfo']['url'],
        'transaction_id' => $response['data']['merchantTransactionId']
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}