<?php

// Start session with secure cookie parameters
session_set_cookie_params([
    'lifetime' => 0,              // Session cookie expires when the browser closes
    'path' => '/',                // Cookie is available in the entire domain
    'domain' => '',               // Default to the current domain
    'secure' => true,             // Cookie only sent over HTTPS
    'httponly' => true,           // Cookie is not accessible via JavaScript
    'samesite' => 'None',         // Explicitly set SameSite attribute to None
]);

session_start();
include 'db.php';

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"));


if (!isset($data->action)) {
    echo json_encode(["message" => "Action is required."]);
    exit();
}

if (!isset($data->user_type) || !in_array($data->user_type, ['user', 'admin'])) {
    echo json_encode(["statusCode" => "400","message" => "User type must be 'user' or 'admin'."]);
    exit();
}

$user_type = $data->user_type;
$table_name = $user_type === 'admin' ? 'admin' : 'users'; // Determine table based on user type
$action = $data->action;

if ($action === "login") {
  if ($user_type === 'user') {
    if (!isset($data->phone)) {
      echo json_encode(["statusCode" => "400", "message" => "Phone number is required."]);
      exit();
    }

    $phone = $data->phone;

    // Check if the user exists in the database by phone number
    $query_phone = "SELECT phone, ID FROM $table_name WHERE phone = ?";
    $stmt_phone = $conn->prepare($query_phone);
    $stmt_phone->execute([$phone]);
    $user_phone = $stmt_phone->fetch(PDO::FETCH_ASSOC);

    // If user found by phone number
    if ($user_phone) {
      // Generate a random 4-digit OTP
      $otp = rand(1000, 9999);

      // **In production, you should send the OTP to the user's phone number**
      // $send_otp_result = send_otp_to_phone($phone, $otp);

      // Simulate successful OTP send (for testing)
      $send_otp_result = true;

      if ($send_otp_result) {
        // Store OTP in a session or database (for verification)
        $_SESSION['otp'] = $otp;
        $_SESSION['phone'] = $phone;

        echo json_encode(["statusCode" => "200", "user" => $user_phone['ID'], "message" => "OTP sent successfully.", "otp" => $otp]);
      } else {
        echo json_encode(["statusCode" => "201", "message" => "Failed to send OTP."]);
      }
    } else {
      echo json_encode(["statusCode" => "201", "message" => "Phone number not found."]);
    }
 } else { // Admin login
    if (!isset($data->email) || !isset($data->password)) {
    echo json_encode(["statusCode" => "400", "message" => "Email and password are required."]);
    exit();
}

$email = $data->email;
$password = $data->password;

// Check if the admin exists in the database by email
$query_email = "SELECT ID, password FROM $table_name WHERE email = ?";
$stmt_email = $conn->prepare($query_email);
$stmt_email->execute([$email]);
$user = $stmt_email->fetch(PDO::FETCH_ASSOC);

if ($user) {
    // Verify password hash
    if (password_verify($password, $user['password'])) {
        // Login successful
        echo json_encode(["statusCode" => "200", "message" => "Login successful."]);
    } else {
        // Incorrect password
        echo json_encode(["statusCode" => "401", "message" => "Incorrect password."]);
    }
} else {
    // Email not found
    echo json_encode(["statusCode" => "401", "message" => "Email address not found."]);
}
 }
}elseif ($action === "verify_otp") {
    if (!isset($data->phone) || !isset($data->otp)) {
        echo json_encode(["statusCode" => "400", "message" => "Phone number and OTP are required."]);
        exit();
    }

    $phone = $data->phone;
    $entered_otp = $data->otp;

    // Check if the stored OTP matches the entered OTP
    if (isset($_SESSION['otp']) && isset($_SESSION['phone']) && $_SESSION['phone'] == $phone && $_SESSION['otp'] == $entered_otp) {
        // OTP verified successfully
        // Retrieve user ID (replace with your actual ID retrieval logic)
        $query_phone = "SELECT ID,first_name FROM $table_name WHERE phone = ?";
        $stmt_phone = $conn->prepare($query_phone);
        $stmt_phone->execute([$phone]);
        $user_phone = $stmt_phone->fetch(PDO::FETCH_ASSOC);

        echo json_encode(["statusCode" => "200", "user" => $user_phone['ID'],"userName" => $user_phone['first_name'], "message" => "Login successful."]);

        // Clear session variables
        unset($_SESSION['otp']);
        unset($_SESSION['phone']);
        
    } else {
        echo json_encode(["statusCode" => "500", "message" => "Invalid OTP."]);
    }
    
    // Remove cookies (if applicable)
        if (isset($_COOKIE['PHPSESSID'])) {
            setcookie("PHPSESSID", "", time() - 3600, "/");
        }
}elseif ($action === "forgot_password") {
    if (!isset($data->email)) {
        echo json_encode(["statusCode" => "400", "message" => "Email address is required."]);
        exit();
    }

    $email = $data->email;

    // Check if the user or admin exists in the database by email
    $query_email = "SELECT ID FROM $table_name WHERE email = ?";
    $stmt_email = $conn->prepare($query_email);
    $stmt_email->execute([$email]);
    $user_email = $stmt_email->fetch(PDO::FETCH_ASSOC);

    if ($user_email) {
        // Generate a random reset token
        $reset_token = bin2hex(random_bytes(32)); 
        // Set token expiry time (e.g., 1 hour)
        $token_expiry = date('Y-m-d H:i:s', time() + 3600); 

        // Update user record with reset token and expiry time
        $query_update = "UPDATE $table_name SET reset_token = ?, token_expiry = ? WHERE email = ?";
        $stmt_update = $conn->prepare($query_update);
        $stmt_update->execute([$reset_token, $token_expiry, $email]);

        // Send the reset link to the user's email
        $reset_link = "https://vsnl.online/servicy/reset-password?token=" . $reset_token; 

        // Send OTP via email
        $subject = "Reset Password Link";
        $message = "Your link to reset password is: $reset_link\n\nThis link will expire in 5 minutes.\n\nThank you!";
        $headers = "From: noreply@yourdomain.com\r\n";
        $headers .= "Reply-To: noreply@yourdomain.com\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        if (mail($email, $subject, $message, $headers)) {
            echo json_encode(["statusCode" => "200", "message" => "Password reset link sent successfully."]);
        } else {
            echo json_encode(["statusCode" => "201", "message" => "Failed to send password reset link. " . $mail->ErrorInfo]);
        }

    } else {
        echo json_encode(["statusCode" => "201", "message" => "Email address not found."]);
    }


 }elseif ($action === "reset_password") {
    if (!isset($data->reset_token) || !isset($data->new_password)) {
        echo json_encode(["statusCode" => "400", "message" => "Reset token and new password are required."]);
        exit();
    }

    $reset_token = $data->reset_token;
    $new_password = password_hash($data->new_password, PASSWORD_DEFAULT);

    $query = "SELECT reset_token FROM $table_name WHERE reset_token = ? AND token_expiry > NOW()";
    $stmt = $conn->prepare($query);
    $stmt->execute([$reset_token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(["statusCode" => "400", "message" => "Invalid or expired reset token."]);
        exit();
    }

    $query = "UPDATE $table_name SET password = ?, reset_token = '', token_expiry = NULL WHERE reset_token = ?";
    $stmt = $conn->prepare($query);
    $stmt->execute([$new_password, $reset_token]);

    echo json_encode(["statusCode" => "200", "message" => ucfirst($user_type) . " password has been reset successfully."]);
} else {
    echo json_encode(["statusCode" => "400", "message" => "Invalid action."]);
}
?>