<?php
header('Content-Type: application/json');
require __DIR__ . '/../vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->safeLoad();

// Initialize PhonePe Client
$client = new PhonePe\Client([
    'merchantId' => $_ENV['PHONEPE_MERCHANT_ID'],
    'saltKey'    => $_ENV['PHONEPE_SALT_KEY'],
    'saltIndex'  => $_ENV['PHONEPE_SALT_INDEX'] ?? 1,
    'env'        => $_ENV['PHONEPE_ENV'] ?? 'sandbox'
]);

try {
    // Get transaction ID from request
    $input = json_decode(file_get_contents('php://input'), true);
    $transactionId = $input['transaction_id'] ?? $_GET['transaction_id'] ?? null;
    
    if (empty($transactionId)) {
        throw new Exception("Transaction ID is required");
    }

    // Fetch transaction details
    $response = $client->payment->getStatus($transactionId);
    
    // Standardize response format
    $data = [
        'transaction_id' => $response['data']['merchantTransactionId'],
        'amount'        => $response['data']['amount'] / 100, // Convert paise to ₹
        'status'        => mapStatus($response['code']),
        'payment_mode'  => $response['data']['paymentInstrument']['type'] ?? null,
        'timestamp'     => $response['data']['transactionDate'],
        'user_reference' => $response['data']['merchantUserId'] ?? null,
        'raw_response'  => $response // Include full PhonePe response
    ];

    echo json_encode([
        'success' => true,
        'data' => $data
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

// Helper function for status mapping (PHP 7.x compatible)
function mapStatus($code) {
    if ($code === 'PAYMENT_SUCCESS') return 'success';
    if ($code === 'PAYMENT_ERROR') return 'failed';
    return 'pending';
}