<?php
include 'db.php';

// Set content type to JSON
header('Content-Type: application/json');

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

// Check if the required fields are provided
if (!$data || !isset($data['category']) || !isset($data['service_slot']) || !isset($data['date']) || !isset($data['location']) || !isset($data['user_id'])) {
    echo json_encode(["status" => "error", "message" => "Invalid input"]);
    exit;
}

// Extract data from the request
$category = $data['category'];
$subcategories = $data['subcategories']; // Now a string, not a JSON array
$date = $data['date'];
$location = $data['location'];
$landmark = isset($data['landmark']) ? $data['landmark'] : null;
$user_id = $data['user_id'];  // Get the user ID from the request
$service_slot = $data['service_slot'];
$status = "Pending Confirmation"; // Default status

// Get the current timestamp for `created_at`
$created_at = date("Y-m-d H:i:s");

// Prepare SQL query to insert data
$sql = "INSERT INTO Service_booking (category, subcategories, date, location, landmark, user_id, status, service_slot, created_at) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);

// Execute the query with bound parameters
if ($stmt->execute([$category, $subcategories, $date, $location, $landmark, $user_id, $status, $service_slot, $created_at])) {
    // Get the unique ID of the newly inserted record
    $id = $conn->lastInsertId();

    // Generate a unique booking ID by concatenating user_id and record ID
    $unique_booking_id = $user_id . "-" . $id;

    // Update the record with the unique booking ID
    $update_sql = "UPDATE Service_booking SET unique_booking_id = ? WHERE id = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->execute([$unique_booking_id, $id]);

    // Send the response with the unique booking ID
    echo json_encode([
        "status" => "success",
        "message" => "Service booking added successfully",
        "unique_booking_id" => $unique_booking_id  // Send the unique booking ID
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "Error: " . $stmt->errorInfo()]);
}

// Close connection
close();
?>